/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.ints;

/**
 * Iterator over a list of int numbers.
 * @see java.util.ListIterator
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface IntListIterator extends IntIterator {
    boolean hasNext();
    int next();
    boolean hasPrevious();
    int previous();
    int nextIndex();
    int previousIndex();
    void remove();
    void set(int e);
    void add(int e);
}
